import os

from core.models.deepMDP_mdl import DeepMDPModel
from core.components.logger import Logger
from core.utils.general_utils import AttrDict
from core.configs.default_data_configs.dmcontrol import data_spec
from core.components.evaluator import DummyEvaluator, ImageEvaluator, MultiImageEvaluator
from core.configs.default_data_configs.carla import data_spec


current_dir = os.path.dirname(os.path.realpath(__file__))


configuration = {
    'model': DeepMDPModel,
    'model_test': DeepMDPModel,
    'logger': Logger,
    'logger_test': Logger,
    'evaluator': DummyEvaluator,
    'data_dir': os.path.join(os.environ['DATA_DIR'], './carla/expert128-town05_h5_L10'),
    'num_epochs': 100,
    'epoch_cycles_train': 7,
    'batch_size': 64,
    'discount_factor': 0.99,
    'n_frames': 3,
    #'gradient_clip': 10,
    'lr': 1e-4,
}
configuration = AttrDict(configuration)

model_config = {
    'action_dim': 2,
    'img_sz': 128,
    'nz_enc': 256,
    'nz_mid': 256,
    'input_nc': 9,
    'normalization': 'none',
    'discount': configuration.discount_factor,
    #'rec_weight': 1.0,
}

# Dataset
data_config = AttrDict()
data_config.dataset_spec = data_spec
data_config.dataset_spec.delta_t = 1
data_config.dataset_spec.task_names = ['right', 'left', 'straight']
